<?php
/**
 * Plugin Name: WooCommerce Web Payment Gateway
 * Plugin URI: https://
 * Description: Accept payments on your WooCommerce site in a seamless and secure checkout environment.
 * Version: 2.0.31
 * Author: SoftSprint
 * Author URI: https://softsprint.net/
 * License: GPL version 2 or later - http://www.gnu.org/licenses/old-licenses/gpl-2.0.html
 * Text Domain: woocommerce-web-payment-gateway
 *
 * @package WordPress
 * @author SoftSprint
 * @since 1.0.0
 */



/**
 * WPG Main Commerce Class
 */
use Automattic\WooCommerce\Blocks\Payments\PaymentMethodRegistry;
class WC_WPG {


	/**
	 * Constructor
	 */
	public function __construct() {
		define( 'WC_WPG_VERSION', '2.0.31' );
		define( 'WC_WPG_TEMPLATE_PATH', untrailingslashit( plugin_dir_path( __FILE__ ) ) . '/templates/' );
		define( 'WC_WPG_PLUGIN_URL', untrailingslashit( plugins_url( basename( plugin_dir_path( __FILE__ ) ), basename( __FILE__ ) ) ) );
		define( 'WC_WPG_PLUGIN_DIR', plugins_url( basename( plugin_dir_path( __FILE__ ) ), basename( __FILE__ ) ) . '/' );
		define( 'WC_WPG_MAIN_FILE', __FILE__ );

		// Actions
		add_filter( 'plugin_action_links_' . plugin_basename( __FILE__ ), array( $this, 'plugin_action_links' ) );
		add_action( 'plugins_loaded', array( $this, 'init' ), 0 );
		add_filter( 'woocommerce_payment_gateways', array( $this, 'register_gateway' ) );
                
		add_action('woocommerce_blocks_loaded',  [$this, 'addBlockSupport']);
		add_action('woocommerce_init', ['WC_Web_Payment_Gateway', 'init_checkout_kunnect_field']);
		add_filter('woocommerce_checkout_fields', ['WC_Web_Payment_Gateway', 'modifyCheckoutFieldsOldHook']);
	}

	/**
	 * Add info and links to plugin in options
	 * @param  array $links
	 * @return array
	 */
	public function plugin_action_links( $links ) {
		$subscriptions = ( class_exists( 'WC_Subscriptions_Order' ) ) ? '_subscriptions' : '';
		if ( class_exists( 'WC_Subscriptions_Order' ) && ! function_exists( 'wcs_create_renewal_order' ) ) {
			$subscriptions = '_subscriptions_deprecated';
		}
		$plugin_links = array(
			'<a href="' . admin_url( 'admin.php?page=wc-settings&tab=checkout&section=wpgfull' . $subscriptions ) . '">' . __( 'Settings', 'woocommerce-web-payment-gateway' ) . '</a>',

		);
		return array_merge( $plugin_links, $links );
	}

	/**
	 * localisations and files
	 */
	public function init() {

		if ( ! class_exists( 'WC_Payment_Gateway' ) ) {
			return;
		}

		// Includes
		include_once( 'includes/class-wc-web-payment-gateway.php' );
		include_once('includes/class-wc-web-payment-gateway-block-support.php');

		include_once('sets/CardOrderInfo.php');
		include_once('sets/Kunnect.php');

		if ( class_exists( 'WC_Subscriptions_Order' ) ) {
			include_once( 'includes/class-wc-web-payment-gateway-subscription.php' );
		}

		// Localisation
		load_plugin_textdomain( 'woocommerce-web-payment-gateway', false, dirname( plugin_basename( __FILE__ ) ) . '/languages' );

	}

	/**
	 * Select the gateway for use
	 */
	public function register_gateway($methods)
	{

		if (
			class_exists('WC_Subscriptions_Order')
		) {
			$methods[] = 'WC_Web_Payment_Gateway_Subscription';
		} else {

			$methods[] = 'WC_Web_Payment_Gateway';
		}

		return $methods;
	}


	public function addBlockSupport()
	{
		if (class_exists('Automattic\WooCommerce\Blocks\Payments\Integrations\AbstractPaymentMethodType')) {
			add_action(
				'woocommerce_blocks_payment_method_type_registration',
				function (PaymentMethodRegistry $payment_method_registry) {
					$payment_method_registry->register(new WC_Web_Payment_Gateway_Blocks_Support);
				}
			);
		}
	}

}


new WC_WPG();
